document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.enable-test-mode').forEach(function(button) {
        button.addEventListener('click', function() {
            var plugin = this.getAttribute('data-plugin');
            var version = this.getAttribute('data-version');
            var reversible = this.getAttribute('data-reversible');

            if (reversible === 'No') {
                if (!confirm('You are about to permanently alter plugin code. DO NOT proceed if you do not have a backup of the current site and a reliable way to restore it. Are you sure you want to proceed?')) {
                    return;
                }
            }

            // Perform AJAX request to enable test mode
            var xhr = new XMLHttpRequest();
            xhr.open('POST', ajaxurl, true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function() {
                if (xhr.status >= 200 && xhr.status < 300) {
                    var response = JSON.parse(xhr.responseText);
                    console.log('success = ' + response.success ? 'YAYS' : 'NOPE');
                    location.reload(); // Reload the page after enabling test mode
                } else {
                    alert('Failed to enable test mode.');
                }
            };
            xhr.send('action=g0dm0d3_enable_test_mode&plugin=' + encodeURIComponent(plugin) + '&version=' + encodeURIComponent(version) + '&_ajax_nonce=' + encodeURIComponent(testModeData.nonce));
        });
    });
});

// .................................................:----=----======++******+==:...........................-+.............................+......................
// ...................................................:--::.:-==+++****++=:........:::......................+-..........................:=-......................
// ....................................................:==++*******+=-:::.......+*%@@%**=...................-+...........................:-......................
// ................................................:-=+**++****+-:............+*%#****#%#++..................+:..........................:=......................
// ...........................................:-=+*******++++=-:.............=#*=+++++++*%+*-................=+...:......................:*:.....................
// ......................................:==++*******+=-:.......::::::......=++-=+***#@%#+%**-................+:.........................::......................
// .................................:-=+********++-:.......................==**%%%#*####*+=%**-...............==.....................::..:-......................
// ............................:-=+********++=-............................=*+*#%%#==%@@#*=*#*+...............:+:.................::......-......................
// ........................:=++*####***++=:................................+*+*#%#=+*=**+=--%**:...............==............:-............-.....................
// .....................:=+*###***++=-:....................................+*===++###%**+=--%%*-................=:.........................::....................
// ................:-=++**#%%%**+-.........................................*#==+**#%@%***=--*@*-................-+.........................--....................
// ............:=++****###**#*+-...........................................##==+*######%#+--*@%:................:+=........................:.....................
// .......:-++**********+=::...............................................*#+++#**##**###++*#*..................==..................:-..::......................
// ..:-=+*********+=-:.....................................................*%#+*%#*#%#%@%##%@%*=.......................................=-::......................
// +*********+=-:........................................................:+#@@%#%%%@@@@@@@@@@%%+-+:..............................................................
// *****+=-:.............................................................=%@@@@%@@@@@@@@@@@@@@%%#=...............................................................
// ++-:.................................................................:*%%@@@@@@@@@@@@@@@@@@%+-..-=:...........................................................
// .....................................................................-.:+*%@-###**####%@@@@@%+##%%######+-....................................................
// .......................................................................:-:+*:.+**#%@@@@@@@@@@%@%%%@%@@#####:..................................................
// ..............................................................................+%@@@@@@@@@@@@@@@@%%%@@@@%###*..................................................
// .............................................................................-%@@@@@@@@@@@@@@@@@@%%%@@@@%*%#-.................................................
// ............................................................................=#@@@##%##@@@@@@@@@@@@@@@@@@@#*#*:................................................
// ........................................................................:-*#*#**++**++*%@@@@@@@@@@@%@@@@@@#*#+................................................
// .....................................................................:##%#*+=*+*%*+++++#@@@@@@@@@@@@@@@@@@%***-...............................................
// ...................................................................-*%%@#===*%#*#+==+++#@@@@@@@@@@@@@@@@@@@%*+*...............................................
// ..................................................................-#%%@+-=#*#*##++*++++%@@@@@@@@@@@@@@@@@@@%%*+=..............................................
// ..................................................................#%@%-=++*#*#***+++*+#@@@@@@@@@@@@@@@@@@@%@@@%+..............................................
// .................................................................+%%%-==+#*+###*+====*@@@@@@@@@@@@@@@@@@@%##%%@@*.............................................
// ................................................................-%@#--=##*#*%#%==+++%@@@@@@@@@@@@@@@%@@@@##*####%+............................................
// ................................................................#@@#-=%#***#%##***#@@@@@@@@@@@@@@@@@@@@@@#****+=-+:...........................................
// ...............................................................*@@@#==#*+**%%#*+*%@@@@@@@@@@@@@@@@@@@@@@@#*****+=:............................................
// ...............................................................:@@@@++#=#*#*#*#@%#*=###@@@@@@@@@@@@@@@@@@#*****+=-:...........................................
// ...............................................................+@@@%=+=+#%#%*+*=+%=##%%@@@@@@@@@@@@@@@@@%%#**#*+===:..........................................
// ...............................................................#@@@%%@#=###=#=+%#%*%@@@@@@@@@@@@@@@@@@@@##%#**+=++=-..........................................
// ..............................................................:#@@##*=##@+%#####+=+@%@@@@@@@@@@@@@@@@@@@@%##*+======-.........................................
// ..............................................................:#%@*+**##%*##+%%+%=@@@@@@@@@@@@@@@@@@@@@@@%%#*++++++==.........................................
// ................................................................-#++%=+*+=**@@#+*@@@%@@@@@@@@@@@@@@@@@@@@@@%**++=+===:........................................
// .................................................................:%@++++#*###%%#%@@@@@@@@@@@@@@@@@@@@@@@@@@%#**+==++=:........................................
// .................................................................:***%+%*%@%@@#%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#++====-.........................................
// .................................................................-**%#*@%@#*#%@@@@@@@@@@@@@@@%@@@@@@@@@@@@@@%#++-----.........................................
// .................................................................=*#%%%#@@@@%@@@@@@@@@@@@@@%@@@@@@@@@@@@%%@@@#+------.........................................
// ................................................................:=#@%%@@@@@%@@@@@@@@@@@@@%@@@@@@@@@@@@@@##@@@#=-----:.........................................
// ...............................................................:=+@@#%@@@@@@@@@@@@@@@@%%@@@@@@@@@@@@@@@%*#@@%:---===-.........................................
// ..............................................................:-=+@##@@@@@@@@@@@@@@%%@@@@@@@@@@@@@@%%@@@##@@+--------.........................................
// ..............................................................-=++##@@@@%%@@@@@%%%@@@@@@@@@@@@@@@@@@@@@@@**-------::..........................................
// .............................................................-=+++@@@@@%%@@@@@@@@@@@@@@@@@%%%%%%@@@@@@@#*--++=--:--:..........................................
// ............................................................:=+++%@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#+-=*#==*+++-:.........................................
// ...........................................................:-++*%@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=-+-.-=+***+*.........................................
// ..........................................................:=+***%%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#++*.:++=*++*==........................................
// .........................................................-=+*###%@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-==.+**#*=#+-.........................................
// ........................................................-+**##*@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#:.+**##*#**-.........................................
// ......................................................:-+**#*+@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#***#*****+..........................................
// .....................................................:--=**+:-@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#+*#***+:............................................
// ..................................................:=--=*=++.-#@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@#:..................................................
// ................................................=+#=+##*+#:.#@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@#..................................................
// ...............................................-+#+=*#%%#:.*%@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@@+.................................................
// ...............................................=**=#*%#+..-%%@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-................................................
// ...............................................=++*##*=...#%@@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*................................................
// .::.............................................:*####*-.+@%@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=...............................................
// =+++-....--.............................................#@@@@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#...............................................
// ++**+=:.-+=:..........................................+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=..............................................
// **+*++==**=-:.......................................:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#..............................................
// +**#***+***++=-=+=-:...............................+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+.............................................
// **#*++***##+++++*++=-:---=====-..................:%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%=............................................
// ******#++*###****+++==++==++++=-::.............-%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#:...........................................
// **##***##*#%#***+++++++++++*+++=--:.............-%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-............................................
// ***##****+************++++++++++=-...............:%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+.............................................
// ******+#*****##*##****+*+*+=++++-.................:#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#..............................................
// *+*+#***=+*+=*##**#*******++++++==---:.............:#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..............................................
// ++#*****=**=*****++*+*******+++**+=----.............:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=..............................................
// ***+++##+*++**#**+=**+++*+++*++++++=----::::........#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#..............................................
// ***+**++****##****+*++**+++*++=====----::-::.::::.:*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%:.............................................
// *++*+*%#**+++**#*********++++*+=-=+=-:-:-::.::::::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=.............................................
// *****####%##*##**********+*++++====-::=-==:.:---::=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*.............................................
// %%%#*####*###**##*#******++**+****+=--==+========:=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.............................................
// ***%##%%**%***+++*#**+++*****+*##**+===++========-=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-............................................
// ##++*****#%#**#**************++*+*++++++====++====+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=............................................
// *#*+**%###*********************++++++++++++++++===+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#............................................
// %%###%%#%@%#%#*%#%**#**%***+++***+++*+*+******+===#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=:..........................................
// *#*######%@%%%###%*######%***+**#++********+*++===@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-:............=-:.....:.-=++---:::.........
// --------=====++*##*#####*******##+***********+++=+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+==-#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%--:-:.......::-===:.:=++++*+++**+*+=::::-..
// :-:::------------------=++*####*************+*++++@@@@@@@@@@@@@@@@@@@@@@@@@@@@+=---=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=--=:..:.::.:-=+++++=+*******##***+++=--===
// ::--::::-:--------------:--------==+***+++++***+++%@@@@@@@@@@@@@@@@@@@@@@@@@@#=-===+*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*--==========++*+++**#***######+*%**++===++
// ------------::::::::-:::--::---::-:---------=++++*+@@@@@@@@@@@@@@@@@@@@@@@@@#+=====+*#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#-=-========++****++**++*#*#*##*#****++++++
// ----------------:----------:::::::::--::------------@@@@@@@@@@@@@@@@@@@@@@@@=+====++*=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=============++*++++*+++*+++****#%#**+++++
// -------------:----------------::----:::-------:::---=@@@@@@@@@@@@@@@@@@@@@@+=+==++++*%+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@===============+++++++++*+*+++++*#**+++++=
// -------:-------------:-------------------------------*@@@@@@@@@@@@@@@@@@@%+=++++++**#*=#@@@@@@@@@@@@@@@@@@@@@@@@@@@@*====+==+=++++++++++++==++*=++*+**#*++++++
// ----------------------------------:-----------------:-%@@@@@@@@@@@@@@@@@%--------=+*#*==@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=+==+=+=+***+++++++++++**+++++***#***++++
// -==---------------=----------------------:-:-----:-:--@@@@@@@@@@@@@@@@@@+--------=======%@@@@@@@@@@@@@@@@@@@@@@@@@@@%====++=+****++***+=+==+**#*++++##**+++*++
// ------=--=-----------------=--------------:-:---------@@@@@@@@@@@@@@@@@@=-------=======+*@@@@@@@@@@@@@@@@@@@@@@@@@@@@==++++++*+*++**==+++*++++**++**+********+
// =====-=====-----=--=-===-=----------------------------@@@@@@@@@@@@@@@@@@=:::::::::-------@@@@@@@@@@@@@@@@@@@@@@@@@@@@==++++*+***+*+++*++++++++***+*####***+**+
// -=-=---=-==-==+----=---==------------------------::--+@@@@@@@@@@@@@@@@@*--::::::::::::-::@@@@@@@@@@@@@@@@@@@@@@@@@@@@#=-=====+++**+*+*+++++++*******#####****+
