<?php
/*
 * Plugin Name: G0dm0d3_XXXL
 * Description: a tool to help developers fight the MATRIX ( test plugins or rescue data without licensing hassles )
 * Version: 1
 * Author: neet-o
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Plugin URI: https://hirugaesu.com/g0dm0d3-xxxl/
 * Requires PHP: 7.4
 * 
 */
// Include PHP Parser autoload (after installing via composer)
require 'vendor/autoload.php';

use PhpParser\ParserFactory;
use PhpParser\PrettyPrinter;
use PhpParser\NodeTraverser;
use PhpParser\NodeVisitorAbstract;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class G0dm0d3_XXXL {


// Array that holds plugin modifications by version
    private $ware;

    // public function __construct() {
    //     add_action('admin_menu', array($this, 'add_tools_page'));
    //     add_action('wp_ajax_enable_test_mode', array($this, 'handle_ajax_enable_test_mode'));
    // }

// Plugin initialization
public function __construct() {
    $this->handle_post_request(); // Move the POST and nonce validation into a separate method
    $this->init_ware();
    add_action('admin_menu', array($this, 'add_tools_menu'));
    add_action('admin_init', array($this, 'register_ajax_actions'));
}

// New method to handle the form submission and nonce validation
public function handle_post_request() {
    if (isset($_POST['action']) && $_POST['action'] === 'G0dmod3_XXXL_reset_enabled_plugins') {
        // Validate nonce
        if (!isset($_POST['g0dm0d3_xxxl_nonce']) || !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['g0dm0d3_xxxl_nonce'] ) ), 'g0dm0d3_xxxl_reset_action')) {
            wp_die('Security check failed.');
        }
        
        // Call the method that handles resetting the enabled plugins
        $this->reset_enabled_plugins_option();
    }
}


    
    
    // Adding the tools menu item
    public function add_tools_menu() {
        add_submenu_page(
            'tools.php',
            'g0dm0d3 XXXL',
            'g0dm0d3 XXXL',
            'manage_options',
            'g0dm0d3-xxxl',
            array($this, 'render_admin_ui')
        );
    }

// Updated render_admin_ui method to include a nonce field in the form
public function render_admin_ui() {
    $detected_plugins = $this->get_compatible_plugins();
    echo '<div class="wrap"><h1>g0dm0d3 XXXL ⇝ Test Mode Manager</h1>';
    
    // Output the table of detected plugins
    echo '<table class="wp-list-table widefat fixed striped">';
    echo '<thead><tr><th>Plugin</th><th>Version</th><th>Actions</th></tr></thead>';
    echo '<tbody>';
    
    foreach ( $detected_plugins as $plugin_slug => $versions ) {
        foreach ( $versions as $version => $data ) {
            $is_enabled = $this->is_test_mode_enabled( $plugin_slug, $version );
            $reversible = $data['reversible'] ? 'Yes' : 'No';
    
            echo '<tr>';
            echo '<td>' . esc_html( $plugin_slug ) . '</td>';
            echo '<td>' . esc_html( $version ) . '</td>';
            echo '<td>';
            if ( $is_enabled ) {
                echo '<span>Test Mode Enabled</span>';
            } else {
                echo '<button class="enable-test-mode" data-plugin="' . esc_attr( $plugin_slug ) . '" data-version="' . esc_attr( $version ) . '" data-reversible="' . esc_attr( $reversible ) . '">Enable Test Mode</button>';
            }
            echo '</td>';
            echo '</tr>';
        }
    }

    echo '</tbody></table>';
    
    // Plugins Supported Section
    echo '<h2>Plugins Supported</h2>';
    $supported_plugins = $this->get_supported_plugins();
    if (!empty($supported_plugins)) {
        echo '<ul>';
        foreach ($supported_plugins as $plugin) {
            echo '<li>' . esc_html($plugin) . '</li>';
        }
        echo '</ul>';
    } else {
        echo '<code>No supported plugins found</code>';
    }

    // System Check Section
    echo '<h2>System Check</h2>';
    echo '<ul>';
    echo '<li>file_put_contents: ' . (function_exists('file_put_contents') ? '<span style="color:green;">OK</span>' : '<span style="color:red;">NO</span>') . '</li>';
    echo '<li>copy: ' . (function_exists('copy') ? '<span style="color:green;">OK</span>' : '<span style="color:red;">NO</span>') . '</li>';
    echo '</ul>';

    // The form with a nonce field
    echo '<form method="post" action="">';
    wp_nonce_field('g0dm0d3_xxxl_reset_action', 'g0dm0d3_xxxl_nonce'); // Add the nonce field here
    echo '<input type="hidden" name="action" value="G0dmod3_XXXL_reset_enabled_plugins">';
    echo '<button id="reset-button" class="button button-primary" type="submit">[dev] Reset Enabled Plugins</button>';
    echo '</form>';

    echo '</div>';

    // Enqueue JS that does AJAX
    $this->enqueue_test_mode_script();
}

	
public function get_supported_plugins() {
    $supported_plugins = [];
    
    foreach ($this->ware as $plugin_slug => $plugin_data) {
        // Use the 'name' field from the $ware array to get the plugin's human-readable name
        $plugin_name = $plugin_data['name'];

        // Process the versions
        $versions = array_keys($plugin_data['versions']);
        
        foreach ($versions as $version) {
            if (strpos($version, '+') !== false) {
                $supported_plugins[] = "$plugin_name $version and up";
            } elseif (strpos($version, '-') !== false) {
                $supported_plugins[] = "$plugin_name up to version " . str_replace('-', '', $version);
            } else {
                $supported_plugins[] = "$plugin_name $version";
            }
        }
    }

    return $supported_plugins;
}


private function get_plugin_file_path( $plugin_slug ) {
    $plugins = get_plugins(); // This returns an array of all installed plugins

    foreach ( $plugins as $plugin_file => $plugin_data ) {
        if ( strpos( $plugin_file, $plugin_slug ) !== false ) {
            return $plugin_file; // Return the path to the main plugin file
        }
    }

    return false; // Return false if no plugin file is found for the slug
}


private function reset_enabled_plugins_option() {
    delete_option('G0dmod3_XXXL_enabled_plugins');
    // wp_redirect(add_query_arg('reset', 'success', wp_get_referer()));
    // exit;
}
    
    
    // init the private $ware var to contain plugins that are compatible and actions to take
    private function init_ware() {
        $this->ware = [
        'elementor-pro' => [
            'name' => 'Elementor Pro',
            'versions' => [
                '3.23.3' => [ // Specific version
                    'actions' => [
                        function() {
                            // Modify a specific file by replacing strings
                            $admin_file = WP_CONTENT_DIR . '/plugins/elementor-pro/license/admin.php';
                            $replacements = [
                                'get_license_key' => 'return "fky00000e7em3nt0r' . substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 20) . '";'
                            ];
                            $this->modify_file( $admin_file, $replacements );
                        },
                        function() {
                            // Modify a different file by replacing strings
                            $api_file = WP_CONTENT_DIR . '/plugins/elementor-pro/license/api.php';
                            $replacements = [
                                'get_license_data' => 'return array( "key" => Admin::get_license_key(), "status" => "valid", "expires" => "lifetime" );',
                                'is_license_active' => 'return TRUE;',
                                'is_license_expired' => 'return FALSE;',
                                'is_licence_pro_trial' => 'return FALSE;',
                                'is_licence_has_feature' => 'return TRUE;',
                                'custom_licence_validator_passed' => 'return TRUE;',
                                'should_allow_all_features' => 'return TRUE;'
                            ];
                            $this->modify_file( $api_file, $replacements );
                        }
                        // , THESE ARE EXAMPLES FOR FUTURE STUFF ... some of this could be used to provide rollbacks
                        // function() {
                        //     // Example: Replace an entire file
                        //     $new_file = WP_CONTENT_DIR . '/custom-modifications/custom-api.php';
                        //     $api_file = WP_CONTENT_DIR . '/plugins/elementor-pro/license/api.php';
                        //     $this->replace_file( $api_file, $new_file );
                        // },
                        // function() {
                        //     // Example: Add a custom filter
                        //     add_filter( 'elementor_pro_some_hook', function() {
                        //         return 'custom_value';
                        //     });
                        // }
                    ],
                    'reversible' => FALSE
                ]
            ]
        ]
    ];
    
    }
    
    
        // Only register AJAX actions if we are in the admin dashboard and plugin is active
    public function register_ajax_actions() {
        if ( is_admin() ) {
            add_action( 'wp_ajax_g0dm0d3_enable_test_mode', array( $this, 'handle_ajax_enable_test_mode' ) );
        }
    }

private function enqueue_test_mode_script() {
    $js_file = plugin_dir_path(__FILE__) . 'js/test-mode.js'; // Adjust the path as needed

    // Check if you want to add a version for cache busting
    $cache_busting = true; // Set this to false to disable cache busting

    if ($cache_busting && file_exists($js_file)) {
        $version = filemtime($js_file); // Get the file modification time
    } else {
        $version = null; // No versioning
    }

    // Register the script
    wp_register_script(
        'test-mode-script',
        plugin_dir_url(__FILE__) . 'js/test-mode.js', // Adjust the path as needed
        array(), // No dependencies
        $version, // Version for cache busting
        true // Load in footer
    );

    // Localize the script with nonce and ajaxurl
    wp_localize_script(
        'test-mode-script',
        'testModeData',
        array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('enable_test_mode_nonce')
        )
    );

    // Enqueue the script
    wp_enqueue_script('test-mode-script');
}


private function is_test_mode_enabled( $plugin_slug, $version ) {
    $enabled_plugins = get_option( 'G0dmod3_XXXL_enabled_plugins', [] );
    return isset( $enabled_plugins[$plugin_slug] ) && $enabled_plugins[$plugin_slug] === $version;
}

private function enable_test_mode( $plugin_slug, $version ) {
    $enabled_plugins = get_option( 'G0dmod3_XXXL_enabled_plugins', [] );
    $enabled_plugins[$plugin_slug] = $version;
    update_option( 'G0dmod3_XXXL_enabled_plugins', $enabled_plugins );
}

    public function handle_ajax_enable_test_mode() {
        if ( ! isset( $_POST['_ajax_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_ajax_nonce'] ) ), 'enable_test_mode_nonce' ) ) {
            wp_send_json_error( 'Invalid POST request: nonce missing or invalid' );
			return;
        }
		
        if ( ! isset( $_POST['plugin'] ) || empty( $_POST['plugin'] ) ) {
            wp_send_json_error( 'Invalid POST request: plugin slug missing' );
			return;
        }
		
		if ( ! isset( $_POST['version'] ) || empty( $_POST['version'] ) ) {
            wp_send_json_error( 'Invalid POST request: plugin version missing' );
			return;
        }

        $plugin = sanitize_text_field( wp_unslash( $_POST['plugin']));
        $version = sanitize_text_field( wp_unslash( $_POST['version']));

        // Execute the actions associated with this plugin/version
        // @TODO add error checking here to ensure actions ran smoothly
        $response = $this->apply_actions( $plugin, $version );
        
        if ( TRUE !== $response ) {
            wp_send_json_error( $response );
            return;
        }

        // Enable test mode and store the status in the options table
        // @TODO add error checking here to ensure options table update ran smoothly
        $this->enable_test_mode( $plugin, $version );

        wp_send_json_success();
    }
    
    
private function get_compatible_plugins() {
    $compatible = [];

    foreach ( $this->ware as $plugin_slug => $plugin_data ) {
        if ( $this->is_plugin_installed( $plugin_slug ) ) {
            foreach ( $plugin_data['versions'] as $version => $version_data ) {
                if ( $this->version_matches( $version, $this->get_plugin_version( $plugin_slug ) ) ) {
                    $compatible[$plugin_slug][$version] = $version_data;
                }
            }
        }
    }

    return $compatible;
}

    private function is_plugin_installed( $plugin_slug ) {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        return is_plugin_active( "$plugin_slug/$plugin_slug.php" );
    }

    // Get the installed version of the plugin
    private function get_plugin_version( $plugin_slug ) {
        if ( ! function_exists( 'get_plugins' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $plugins = get_plugins();
        if ( isset( $plugins["$plugin_slug/$plugin_slug.php"] ) ) {
            return $plugins["$plugin_slug/$plugin_slug.php"]['Version'];
        }
        return null;
    }

    // Check if we can modify the specified plugin version
    private function can_modify_version( $plugin_slug, $version ) {
        if ( isset( $this->ware[$plugin_slug] ) ) {
            foreach ( $this->ware[$plugin_slug]['versions'] as $target_version => $data ) {
                if ( $this->version_matches( $target_version, $version ) ) {
                    return true;
                }
            }
        }
        return false;
    }

    // Compare version numbers with support for + or - symbols
    private function version_matches( $target_version, $current_version ) {
        if ( strpos( $target_version, '+' ) !== false ) {
            // Matches this version and higher
            $target_version = str_replace( '+', '', $target_version );
            return version_compare( $current_version, $target_version, '>=' );
        } elseif ( strpos( $target_version, '-' ) !== false ) {
            // Matches this version and lower
            $target_version = str_replace( '-', '', $target_version );
            return version_compare( $current_version, $target_version, '<=' );
        } else {
            // Exact version match
            return version_compare( $current_version, $target_version, '==' );
        }
    }

    // Apply the actions defined for the plugin version
    private function apply_actions( $plugin_slug, $version ) {
        if ( !$plugin_slug ) return "PLUGIN SLUG EMPTY";
        if ( !$version ) return "PLUGIN VERSION EMPTY";
        
        $actions = $this->ware[$plugin_slug]['versions'][$version]['actions'];

        if ( !$actions || empty( $actions ) ) return "NO ACTIONS FOR " . $plugin_slug . " " . $version;

        foreach ( $actions as $action ) {
            $action(); // Execute the anonymous function
            // @TODO do some checking on these
            
        }
        
        return TRUE;
    }


    
private function modify_file($file_path, $replacements) {
    // Check if the file exists
    if (!file_exists($file_path)) {
        return false;
    }

    // Get the file content
    $code = WP_Filesystem_Direct::get_contents($file_path);

    // Parse the file content using PHP-Parser
    $parser = (new ParserFactory())->createForNewestSupportedVersion();
    $traverser = new NodeTraverser();
    $prettyPrinter = new PrettyPrinter\Standard;

    // Apply the replacements
    try {
        $stmts = $parser->parse($code);

        // Custom node visitor to find and replace specific nodes
        $traverser->addVisitor(new class($replacements, $parser) extends NodeVisitorAbstract {
            private $replacements;
            private $parser;

            public function __construct($replacements, $parser) {
                $this->replacements = $replacements;
                $this->parser = $parser;
            }

            public function enterNode(\PhpParser\Node $node) {
                foreach ($this->replacements as $original => $replacement) {
                    if ($node instanceof \PhpParser\Node\Stmt\ClassMethod && $node->name->toString() === $original) {
                        // Parse the replacement as an expression to properly inject PHP code
                        $replacement_expr = $this->parser->parse('<?php ' . $replacement . ';');
                        
                        // Set the method's statements to the parsed expression
                        $node->stmts = $replacement_expr;
                    }
                }
            }
        });

        $stmts = $traverser->traverse($stmts);
        $new_code = $prettyPrinter->prettyPrintFile($stmts);

        // Write the modified code back to the file
        WP_Filesystem_Direct::put_contents($file_path, $new_code);

    } catch (\PhpParser\Error $e) {
        echo esc_html('Parse error: ', $e->getMessage());
    }
}

    
    // Utility function to replace one file with another
    private function replace_file( $target_file, $new_file ) {
        if ( ! file_exists( $new_file ) || ! file_exists( $target_file ) ) {
            return;
        }

        copy( $new_file, $target_file );
    }

}

new G0dm0d3_XXXL(); // GO TIME


// .................................................:----=----======++******+==:...........................-+.............................+......................
// ...................................................:--::.:-==+++****++=:........:::......................+-..........................:=-......................
// ....................................................:==++*******+=-:::.......+*%@@%**=...................-+...........................:-......................
// ................................................:-=+**++****+-:............+*%#****#%#++..................+:..........................:=......................
// ...........................................:-=+*******++++=-:.............=#*=+++++++*%+*-................=+...:......................:*:.....................
// ......................................:==++*******+=-:.......::::::......=++-=+***#@%#+%**-................+:.........................::......................
// .................................:-=+********++-:.......................==**%%%#*####*+=%**-...............==.....................::..:-......................
// ............................:-=+********++=-............................=*+*#%%#==%@@#*=*#*+...............:+:.................::......-......................
// ........................:=++*####***++=:................................+*+*#%#=+*=**+=--%**:...............==............:-............-.....................
// .....................:=+*###***++=-:....................................+*===++###%**+=--%%*-................=:.........................::....................
// ................:-=++**#%%%**+-.........................................*#==+**#%@%***=--*@*-................-+.........................--....................
// ............:=++****###**#*+-...........................................##==+*######%#+--*@%:................:+=........................:.....................
// .......:-++**********+=::...............................................*#+++#**##**###++*#*..................==..................:-..::......................
// ..:-=+*********+=-:.....................................................*%#+*%#*#%#%@%##%@%*=.......................................=-::......................
// +*********+=-:........................................................:+#@@%#%%%@@@@@@@@@@%%+-+:..............................................................
// *****+=-:.............................................................=%@@@@%@@@@@@@@@@@@@@%%#=...............................................................
// ++-:.................................................................:*%%@@@@@@@@@@@@@@@@@@%+-..-=:...........................................................
// .....................................................................-.:+*%@-###**####%@@@@@%+##%%######+-....................................................
// .......................................................................:-:+*:.+**#%@@@@@@@@@@%@%%%@%@@#####:..................................................
// ..............................................................................+%@@@@@@@@@@@@@@@@%%%@@@@%###*..................................................
// .............................................................................-%@@@@@@@@@@@@@@@@@@%%%@@@@%*%#-.................................................
// ............................................................................=#@@@##%##@@@@@@@@@@@@@@@@@@@#*#*:................................................
// ........................................................................:-*#*#**++**++*%@@@@@@@@@@@%@@@@@@#*#+................................................
// .....................................................................:##%#*+=*+*%*+++++#@@@@@@@@@@@@@@@@@@%***-...............................................
// ...................................................................-*%%@#===*%#*#+==+++#@@@@@@@@@@@@@@@@@@@%*+*...............................................
// ..................................................................-#%%@+-=#*#*##++*++++%@@@@@@@@@@@@@@@@@@@%%*+=..............................................
// ..................................................................#%@%-=++*#*#***+++*+#@@@@@@@@@@@@@@@@@@@%@@@%+..............................................
// .................................................................+%%%-==+#*+###*+====*@@@@@@@@@@@@@@@@@@@%##%%@@*.............................................
// ................................................................-%@#--=##*#*%#%==+++%@@@@@@@@@@@@@@@%@@@@##*####%+............................................
// ................................................................#@@#-=%#***#%##***#@@@@@@@@@@@@@@@@@@@@@@#****+=-+:...........................................
// ...............................................................*@@@#==#*+**%%#*+*%@@@@@@@@@@@@@@@@@@@@@@@#*****+=:............................................
// ...............................................................:@@@@++#=#*#*#*#@%#*=###@@@@@@@@@@@@@@@@@@#*****+=-:...........................................
// ...............................................................+@@@%=+=+#%#%*+*=+%=##%%@@@@@@@@@@@@@@@@@%%#**#*+===:..........................................
// ...............................................................#@@@%%@#=###=#=+%#%*%@@@@@@@@@@@@@@@@@@@@##%#**+=++=-..........................................
// ..............................................................:#@@##*=##@+%#####+=+@%@@@@@@@@@@@@@@@@@@@@%##*+======-.........................................
// ..............................................................:#%@*+**##%*##+%%+%=@@@@@@@@@@@@@@@@@@@@@@@%%#*++++++==.........................................
// ................................................................-#++%=+*+=**@@#+*@@@%@@@@@@@@@@@@@@@@@@@@@@%**++=+===:........................................
// .................................................................:%@++++#*###%%#%@@@@@@@@@@@@@@@@@@@@@@@@@@%#**+==++=:........................................
// .................................................................:***%+%*%@%@@#%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#++====-.........................................
// .................................................................-**%#*@%@#*#%@@@@@@@@@@@@@@@%@@@@@@@@@@@@@@%#++-----.........................................
// .................................................................=*#%%%#@@@@%@@@@@@@@@@@@@@%@@@@@@@@@@@@%%@@@#+------.........................................
// ................................................................:=#@%%@@@@@%@@@@@@@@@@@@@%@@@@@@@@@@@@@@##@@@#=-----:.........................................
// ...............................................................:=+@@#%@@@@@@@@@@@@@@@@%%@@@@@@@@@@@@@@@%*#@@%:---===-.........................................
// ..............................................................:-=+@##@@@@@@@@@@@@@@%%@@@@@@@@@@@@@@%%@@@##@@+--------.........................................
// ..............................................................-=++##@@@@%%@@@@@%%%@@@@@@@@@@@@@@@@@@@@@@@**-------::..........................................
// .............................................................-=+++@@@@@%%@@@@@@@@@@@@@@@@@%%%%%%@@@@@@@#*--++=--:--:..........................................
// ............................................................:=+++%@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#+-=*#==*+++-:.........................................
// ...........................................................:-++*%@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=-+-.-=+***+*.........................................
// ..........................................................:=+***%%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#++*.:++=*++*==........................................
// .........................................................-=+*###%@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-==.+**#*=#+-.........................................
// ........................................................-+**##*@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#:.+**##*#**-.........................................
// ......................................................:-+**#*+@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#***#*****+..........................................
// .....................................................:--=**+:-@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@#+*#***+:............................................
// ..................................................:=--=*=++.-#@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@#:..................................................
// ................................................=+#=+##*+#:.#@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@#..................................................
// ...............................................-+#+=*#%%#:.*%@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%@@@@+.................................................
// ...............................................=**=#*%#+..-%%@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-................................................
// ...............................................=++*##*=...#%@@@@@@@@%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*................................................
// .::.............................................:*####*-.+@%@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=...............................................
// =+++-....--.............................................#@@@@@@@@@@@%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#...............................................
// ++**+=:.-+=:..........................................+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=..............................................
// **+*++==**=-:.......................................:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#..............................................
// +**#***+***++=-=+=-:...............................+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+.............................................
// **#*++***##+++++*++=-:---=====-..................:%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%%=............................................
// ******#++*###****+++==++==++++=-::.............-%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#:...........................................
// **##***##*#%#***+++++++++++*+++=--:.............-%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-............................................
// ***##****+************++++++++++=-...............:%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+.............................................
// ******+#*****##*##****+*+*+=++++-.................:#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#..............................................
// *+*+#***=+*+=*##**#*******++++++==---:.............:#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..............................................
// ++#*****=**=*****++*+*******+++**+=----.............:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=..............................................
// ***+++##+*++**#**+=**+++*+++*++++++=----::::........#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%#..............................................
// ***+**++****##****+*++**+++*++=====----::-::.::::.:*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%:.............................................
// *++*+*%#**+++**#*********++++*+=-=+=-:-:-::.::::::-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=.............................................
// *****####%##*##**********+*++++====-::=-==:.:---::=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*.............................................
// %%%#*####*###**##*#******++**+****+=--==+========:=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.............................................
// ***%##%%**%***+++*#**+++*****+*##**+===++========-=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%-............................................
// ##++*****#%#**#**************++*+*++++++====++====+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=............................................
// *#*+**%###*********************++++++++++++++++===+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#............................................
// %%###%%#%@%#%#*%#%**#**%***+++***+++*+*+******+===#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=:..........................................
// *#*######%@%%%###%*######%***+**#++********+*++===@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-:............=-:.....:.-=++---:::.........
// --------=====++*##*#####*******##+***********+++=+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+==-#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%--:-:.......::-===:.:=++++*+++**+*+=::::-..
// :-:::------------------=++*####*************+*++++@@@@@@@@@@@@@@@@@@@@@@@@@@@@+=---=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=--=:..:.::.:-=+++++=+*******##***+++=--===
// ::--::::-:--------------:--------==+***+++++***+++%@@@@@@@@@@@@@@@@@@@@@@@@@@#=-===+*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*--==========++*+++**#***######+*%**++===++
// ------------::::::::-:::--::---::-:---------=++++*+@@@@@@@@@@@@@@@@@@@@@@@@@#+=====+*#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#-=-========++****++**++*#*#*##*#****++++++
// ----------------:----------:::::::::--::------------@@@@@@@@@@@@@@@@@@@@@@@@=+====++*=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=============++*++++*+++*+++****#%#**+++++
// -------------:----------------::----:::-------:::---=@@@@@@@@@@@@@@@@@@@@@@+=+==++++*%+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@===============+++++++++*+*+++++*#**+++++=
// -------:-------------:-------------------------------*@@@@@@@@@@@@@@@@@@@%+=++++++**#*=#@@@@@@@@@@@@@@@@@@@@@@@@@@@@*====+==+=++++++++++++==++*=++*+**#*++++++
// ----------------------------------:-----------------:-%@@@@@@@@@@@@@@@@@%--------=+*#*==@@@@@@@@@@@@@@@@@@@@@@@@@@@@%=+==+=+=+***+++++++++++**+++++***#***++++
// -==---------------=----------------------:-:-----:-:--@@@@@@@@@@@@@@@@@@+--------=======%@@@@@@@@@@@@@@@@@@@@@@@@@@@%====++=+****++***+=+==+**#*++++##**+++*++
// ------=--=-----------------=--------------:-:---------@@@@@@@@@@@@@@@@@@=-------=======+*@@@@@@@@@@@@@@@@@@@@@@@@@@@@==++++++*+*++**==+++*++++**++**+********+
// =====-=====-----=--=-===-=----------------------------@@@@@@@@@@@@@@@@@@=:::::::::-------@@@@@@@@@@@@@@@@@@@@@@@@@@@@==++++*+***+*+++*++++++++***+*####***+**+
// -=-=---=-==-==+----=---==------------------------::--+@@@@@@@@@@@@@@@@@*--::::::::::::-::@@@@@@@@@@@@@@@@@@@@@@@@@@@@#=-=====+++**+*+*+++++++*******#####****+
